#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Rockpools_bumps from depthmapMod01.fsh   by   DwayneBrah  
//https://www.shadertoy.com/view/dt23RK
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.5 //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// No polygons or trigonometry functions were hurt during production 

// OK. This started out as a very efficient faux-bumpmapper 
// designed to replace a non-GL, complex paralax scroller in my android game

// I got carried away and added a ton of other things that dent performance significantly.
// This is by no means a set of best practices, i don't think any of the effects are calculated 
// with correct triganometry. But it sure is useful in adding depth to game backgrounds etc.

// I've left this over-verbose version here for easy comprehension.

float phase;
vec2 light_direction = vec2(0.040, 0.040);
float extrude_amount = 0.12;
float water_level = 0.34;
float height_multiplier_master = 1.00;

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    
    vec2 uv = fragCoord/iResolution.xy;
    vec2 mouse = iMouse.xy/iResolution.xy;
    
    if (mouse.x == 0.00) {
        mouse.x = 0.50;
        mouse.y = 0.50;
    }
    
    
    // Phase and pan
    phase = iTime/10.00;
    vec2 pan_offset = vec2(sin(phase), cos(phase));
    float view_distance = sin(phase)*0.40+0.90;
    
    
    
    // Zoom calcs
    vec2 from_middle = (uv-vec2(0.5,0.5));
    vec2 full_zoom_pixel_offset = 0.00-(from_middle*extrude_amount);
    
    vec2 base_texture_coord = (uv+pan_offset)*view_distance;
    
    
    vec2 flat_image_coord = base_texture_coord;
    vec4 flat_image = texture2D(texture1, flat_image_coord);
    
    
    float decided_lightness = 1.00;
    float decided_height_level = 0.00;
    float decided_height_level_actual = 0.00;
    
    vec2 decided_zoomed_texture_coord;
    vec4 decided_zoomed_image = flat_image;
    
    
    float current_check_height = 0.00;
    float current_step = 0.00;
    

    float height_step = 0.06;
    for (float zoom_level_to_check = 0.00; zoom_level_to_check < 1.00; zoom_level_to_check += 0.10) {
        
        // Get height at this zoom level
        vec2 zoomed_texture_coord = base_texture_coord+(full_zoom_pixel_offset*zoom_level_to_check);
        vec4 zoomed_texture = texture2D(texture0, zoomed_texture_coord);
        vec4 zoomed_image_for_bumps = texture2D(texture1, zoomed_texture_coord);
        float this_zoomed_height = zoomed_texture.r;
        
        // vary height
        float height_multiplier = height_multiplier_master * sin(zoomed_texture_coord.x);
        this_zoomed_height -= height_multiplier*0.05;
        
        // Experimental crude bumpmapping from image
        float ground_intensity = (zoomed_image_for_bumps.r + zoomed_image_for_bumps.g +zoomed_image_for_bumps.b)/3.00;
        this_zoomed_height -= (0.30-clamp(ground_intensity, 0.00, 0.30))*0.10;
        
        // Where is the slope facing?
        vec4 zoomed_texture_displaced = texture2D(texture0, zoomed_texture_coord+light_direction);
        float facing_height = zoomed_texture_displaced.r;
        float steepness = facing_height/this_zoomed_height;
        float gradient_to_light = 0.50;
        float gradient_closeness = gradient_to_light-steepness;
        float lightness = 1.00 / gradient_closeness;
        lightness = 1.00 + 1.00 * gradient_closeness;
        
        vec2 zoomed_image_coord = base_texture_coord+(full_zoom_pixel_offset*zoom_level_to_check);
        vec4 zoomed_image = texture2D(texture1, zoomed_image_coord*1.1);
        
        // Log the highest point found
        if (this_zoomed_height >= current_check_height) {
            
            // Fading the edges - not essential looks better with fewer slices
            float fadedness = (this_zoomed_height - current_check_height)*10.00;
            
            if (fadedness < 1.00) {
                 decided_zoomed_image = mix(decided_zoomed_image, zoomed_image, fadedness);
            } else {
                 decided_zoomed_image = zoomed_image;
            }
            
            
            decided_zoomed_texture_coord = zoomed_texture_coord;
            decided_lightness = lightness;
            decided_height_level = current_check_height;
            decided_height_level_actual = this_zoomed_height;
        }
        
        current_step += 1.00;
        
        
        float perspective_exaggerate = 0.006;
        current_check_height = (current_step*height_step)*(1.00-(current_step*perspective_exaggerate));

    }
    
    // Find shadow
    vec2 shadow_sample_offset;
    vec2 zoomed_texture_coord_shadow_sample;
    float shadow_amount = 0.00;
    for (float shadow_distance = -0.10; shadow_distance < 1.00; shadow_distance += 0.20) {
        
        shadow_sample_offset = vec2(light_direction.x, light_direction.y)*shadow_distance;
        zoomed_texture_coord_shadow_sample = decided_zoomed_texture_coord+shadow_sample_offset;
        vec4 zoomed_texture_shadow_sample = texture2D(texture0, zoomed_texture_coord_shadow_sample);
        float this_shadow_sample_height = zoomed_texture_shadow_sample.r;
        
        float shadow_angle = 0.19;
        if (decided_height_level_actual-0.15 < water_level) {
            if (water_level <= this_shadow_sample_height) {
                shadow_amount = 0.02;
            } else {
                // Diminished shadows underwater
                shadow_amount = 0.00;
            }
        } else {
            // If above water
            if (decided_height_level_actual+shadow_angle < this_shadow_sample_height) {
                shadow_amount = 0.30;
            }

        }
        
    }
    
    
    // Calculate coast
    float cost_size = 0.30;
    float coast_amount = 0.00;
    if (decided_height_level < water_level+cost_size) {
        if (decided_height_level > water_level-cost_size) {
            
            float dist_from_surface = abs (water_level-decided_height_level);
            dist_from_surface *= (1.00/cost_size);
            if (dist_from_surface == 0.00) {
                dist_from_surface = 0.01;
            }
            
            coast_amount = 0.10*(0.20/dist_from_surface);
            
        }
    }
    

    // Mixing
    vec4 final_color = decided_zoomed_image;
    
    // Improve land visibilty
    float base_lightness = 0.10;
    final_color = final_color + base_lightness;

    // Apply shadow to land
    final_color -= shadow_amount;
    
    // Apply coast
    if (coast_amount > 0.00) {
        
       vec4 coast_color = vec4(-0.10, -0.20, -0.80, 1.00);
       final_color = mix(final_color, coast_color, coast_amount*0.33);
        
    }
    
    // Lighting
    float lighting_amount = 1.00;
    float lightness_multiplier = (-0.00+decided_lightness*lighting_amount);
    lightness_multiplier = clamp(lightness_multiplier, -0.20, 1.20);
    vec4 final_color_lit = final_color*lightness_multiplier;
    final_color = mix(final_color, final_color_lit, 0.70);
    
    // Fake occlusion at depth
    vec4 fog_color = vec4(0.04, 0.15, 0.15, 1.00);
    float fog_height = 0.30;
    if (decided_height_level_actual < fog_height) {
    
        float fog_intensity = 1.00 - (decided_height_level_actual*(1.00/fog_height));
        final_color = mix(final_color, fog_color, fog_intensity); 
        
    }
    
    // Water
    vec2 sheen_point = vec2(0.75, 0.75);
    float distace_from_sheen = abs(distance(sheen_point, uv));
    if (decided_height_level < water_level) {
    
        vec4 water_color = vec4(68.00/256.00, 200.00/256.00, 255.00/256.00, 1.00);

        final_color = final_color*water_color;
        float water_lightness = 0.60;
        final_color *= water_lightness;
        
        // water sheen
        float sheen_dropoff = 0.80;
        float sheen_amount = 0.05/(distace_from_sheen*sheen_dropoff);
        
        float sheen_mix = 0.90;
        float default_sheen = 0.20;
        if (shadow_amount == 0.00) {
            final_color += clamp((sheen_amount)*sheen_mix, 0.00, 0.80);
        }
        
        final_color += default_sheen;
        
    }
    
    // Specular
    float clamp_start = 0.90;
    if (shadow_amount == 0.00 && (decided_height_level > water_level || coast_amount > 0.10)) {
        float sheen_amount = 2.10/(distace_from_sheen*1.60);
    
        float specular_clamp = clamp(lightness_multiplier, clamp_start, 2.00)-clamp_start;
        float specular_amount = specular_clamp*specular_clamp*specular_clamp;
        final_color += specular_amount*sheen_amount;
    }
    
    // Vignette
    float vignette_intensity = 0.10;
    float closeness_to_edge_x = abs(uv-0.50).x * 2.00;
    float closeness_to_edge_y = abs(uv-0.50).y * 2.00;
    float vignette_darkening = (closeness_to_edge_x*closeness_to_edge_x*closeness_to_edge_x + closeness_to_edge_y*closeness_to_edge_y);
    final_color -= mix(final_color, vec4(0.00, 0.00, 0.00, 1.00), 1.00-vignette_darkening*vignette_intensity);
    
    // Output
    fragColor = final_color;

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

